/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.supplycrate;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.entities.ParachuteEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class SupplyCrateUpgrade
extends LargeUpgrade
implements MenuProvider {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(27);
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);

    public SupplyCrateUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)((Object)SimplePlanesUpgrades.SUPPLY_CRATE.get()), planeEntity);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.itemStackHandler.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.m_85836_();
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.m_85837_(0.0, 0.0, -0.15);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.m_85837_(0.0, 0.0, 0.1);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-0.4, -1.0, 0.3);
        matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
        BlockState state = Blocks.f_50618_.m_49966_();
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.m_85841_(0.875f, 0.875f, 0.875f);
        matrixStack.m_85837_(0.0625, 0.25, 0.0625);
        state = Blocks.f_50041_.m_49966_();
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.m_85849_();
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.planeEntity.m_19983_(itemStack);
        }
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.SUPPLY_CRATE.get());
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    public Component m_5446_() {
        return new TranslatableComponent("simpleplanes:supply_crate");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventoryIn, Player playerEntity) {
        return new StorageContainer(id, playerInventoryIn, (IItemHandler)this.itemStackHandler, Items.f_42768_.getRegistryName().toString());
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void openStorageGui(ServerPlayer player) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, buffer -> buffer.m_130070_(Items.f_42768_.getRegistryName().toString()));
    }

    @Override
    public boolean canBeDroppedAsPayload() {
        return true;
    }

    @Override
    public void dropAsPayload() {
        ParachuteEntity parachuteEntity = new ParachuteEntity(this.planeEntity.f_19853_, this.itemStackHandler);
        parachuteEntity.m_146884_(this.planeEntity.m_20182_());
        parachuteEntity.m_20256_(this.planeEntity.m_20184_());
        this.planeEntity.f_19853_.m_7967_((Entity)parachuteEntity);
        this.remove();
    }
}

